/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.busy;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.busy.BusyBean;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.servlet.pmod.PanelModel;
import com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal;
import com.ibm.hwmca.fw.servlet.pmod.task.TaskEndedException;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.task.PanelDisplayer;
import com.ibm.hwmca.fw.task.PanelInvoker;
import com.ibm.hwmca.fw.task.TaskErrorIds;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.HMCUserTaskManager;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.NamedTimer;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.TaskManagerException;
import com.ibm.ui.framework.UserTaskManager;
import java.util.Timer;
import java.util.TimerTask;

public class BusyDialog
implements PanelInvoker,
TaskActionListener,
TaskErrorIds {
    private static final String TRACE_MASKT = "XFRMBSYT";
    private static final String TRACE_MASKF = "XFRMBSYF";
    private static final String TRACE_MASKD = "XFRMBSYD";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.fw.busy.res.BusyRes";
    private static final String PANEL_NAME = "BusyPanel";
    private static final long MINIMUM_SHOW_TIME = 2500L;
    private static final int THRASH_SUPPRESSION_THRESHOLD = 500;
    private static final Timer timer = new NamedTimer(true, "BusyDialog Timer");
    private String title;
    private String message;
    private UserTaskManager parent;
    private boolean destroyed = false;
    private UserTaskManager utm = null;
    private long startTime = 0L;
    private long showTime = 2500L;
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "BusyDialog");

    public BusyDialog(LocalizableText title, LocalizableText message, UserTaskManager parent) throws HException {
        Trace.trace(TRACE_MASKT, "-> BusyDialog()");
        this.show(title.toString(), message.toString(), parent);
        Trace.trace(TRACE_MASKT, "<- BusyDialog()");
    }

    public BusyDialog(LocalizableText title, LocalizableText message) throws HException {
        this(title, message, null);
    }

    public BusyDialog(UIInfo taskInfo, LocalizableText message) throws HException {
        Trace.trace(TRACE_MASKT, "-> BusyDialog()");
        Object[] subst = new String[]{taskInfo.getTitle()};
        LocalizableText title = new LocalizableText("com/ibm/hwmca/fw/res/common", "busy.task.title", subst);
        this.show(title.toString(), message.toString(), null);
        Trace.trace(TRACE_MASKT, "<- BusyDialog()");
    }

    public BusyDialog(UIInfo taskInfo) throws HException {
        Trace.trace(TRACE_MASKT, "-> BusyDialog()");
        Object[] subst = new String[]{taskInfo.getTitle()};
        LocalizableText title = new LocalizableText("com/ibm/hwmca/fw/res/common", "busy.task.title", subst);
        LocalizableText message = new LocalizableText("com/ibm/hwmca/fw/res/common", "busy.task.text", subst);
        this.show(title.toString(), message.toString(), null);
        Trace.trace(TRACE_MASKT, "<- BusyDialog()");
    }

    private void show(String title, String message, UserTaskManager parent) throws HException {
        Trace.trace(TRACE_MASKT, "-> BusyDialog.show()");
        this.title = title;
        this.message = message;
        this.parent = parent;
        PanelDisplayer.display(this);
        Trace.trace(TRACE_MASKT, "<- BusyDialog.show()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeImpl() {
        Trace.trace(TRACE_MASKT, "-> BusyDialog().invokeImpl()");
        try {
            BusyDialog busyDialog = this;
            synchronized (busyDialog) {
                if (!this.destroyed) {
                    BusyBean bean = new BusyBean();
                    Object[] beans = new BusyBean[]{bean};
                    this.startTime = System.currentTimeMillis();
                    this.utm = new HMCUserTaskManager(AUIML_FILE_NAME, PANEL_NAME, beans, null, this.parent);
                    this.title = this.title.replace('\n', ' ');
                    this.utm.setCaptionText(PANEL_NAME, this.title);
                    this.utm.setCaptionText("BusyMsgOutput", this.message);
                    this.utm.addCancelListener((TaskActionListener)this);
                } else {
                    Trace.trace(TRACE_MASKT, "BusyDialog() invoke supressed, dialog already disposed.");
                }
            }
            if (!this.destroyed) {
                this.utm.invoke();
            }
        }
        catch (TaskManagerException exc) {
            HException ex = new HException(exc);
            new FrameworkLog(classLogInfo, 52, ex).log();
        }
        Trace.trace(TRACE_MASKT, "<- BusyDialog().invokeImpl()");
    }

    public void invoke() {
        block5: {
            if (CommonSystem.getCommonSystem().isUsingHTML()) {
                try {
                    if (PanelModel.getThreadLocalPanelModelTaskPortal().isPanelStackEmpty()) {
                        Trace.trace(TRACE_MASKT, "BusyDialog() stack empty, calling invokeImpl().");
                        this.invokeImpl();
                        break block5;
                    }
                    final PanelModelTaskPortal portal = PanelModel.getThreadLocalPanelModelTaskPortal();
                    final int modificationLevel = portal.getModificationLevel();
                    Trace.trace(TRACE_MASKT, "BusyDialog() Scheduling timer +500 into future.");
                    timer.schedule(new TimerTask(){

                        public void run() {
                            new Thread(this){
                                private final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void run() {
                                    block5: {
                                        Trace.trace("XFRMBSYT", "BusyDialog() Timer pops.");
                                        PanelModel.setThreadLocalPanelModelTaskPortal(1.access$000(this.this$1));
                                        try {
                                            if (1.access$100(this.this$1) == 1.access$000(this.this$1).getModificationLevel()) {
                                                if (!1.access$000(this.this$1).isTaskEnded()) {
                                                    BusyDialog.access$300(1.access$200(this.this$1));
                                                } else {
                                                    Trace.trace("XFRMBSYT", "BusyDialog() Timer ignoring invocation (panel task ended).");
                                                }
                                                break block5;
                                            }
                                            Trace.trace("XFRMBSYT", "BusyDialog() Timer ignoring invocation (panel stack has changed).");
                                        }
                                        catch (Exception e) {}
                                    }
                                }
                            }.start();
                        }

                        static /* synthetic */ PanelModelTaskPortal access$000(1 x0) {
                            return x0.portal;
                        }

                        static /* synthetic */ int access$100(1 x0) {
                            return x0.modificationLevel;
                        }

                        static /* synthetic */ BusyDialog access$200(1 x0) {
                            return x0.BusyDialog.this;
                        }
                    }, 500L);
                }
                catch (TaskEndedException e) {}
            } else {
                this.invokeImpl();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForComplete() {
        BusyDialog busyDialog = this;
        synchronized (busyDialog) {
            while (!this.destroyed) {
                try {
                    this.wait();
                }
                catch (InterruptedException exc) {
                    // empty catch block
                }
            }
            return;
        }
    }

    public String getCallerId() {
        return new String("BusyDialog");
    }

    public boolean registerAsHMCSessionListener() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Trace.trace(TRACE_MASKT, "-> BusyDialog.destroy()");
        BusyDialog busyDialog = this;
        synchronized (busyDialog) {
            if (this.utm != null) {
                long curTime = System.currentTimeMillis();
                if (this.startTime + this.showTime < curTime || this.startTime == 0L) {
                    Trace.trace(TRACE_MASKF, "disposing busy immediately; startTime=" + this.startTime + ";shotTime=" + this.showTime + "; curTime=" + curTime);
                    this.utm.dispose();
                } else {
                    UserTaskManager finalUtm = this.utm;
                    final long waitTime = this.showTime;
                    final long displayTime = this.startTime;
                    try {
                        new Thread("Busy Dialog Destroy Thread"){

                            public void run() {
                                try {
                                    long waitStart = System.currentTimeMillis();
                                    long waitEnd = displayTime + waitTime;
                                    while (waitEnd > waitStart) {
                                        Trace.trace(BusyDialog.TRACE_MASKF, "in wait loop; waitEnd=" + waitEnd + ";waitStart=" + waitStart);
                                        try {
                                            Thread.currentThread();
                                            Thread.sleep(waitEnd - waitStart);
                                        }
                                        catch (InterruptedException e) {
                                            // empty catch block
                                        }
                                        waitStart = System.currentTimeMillis();
                                    }
                                }
                                catch (Exception ex) {
                                    Trace.trace(BusyDialog.TRACE_MASKF, "Caught exception in busy thread: " + ex);
                                }
                                BusyDialog.this.utm.dispose();
                                Trace.trace(BusyDialog.TRACE_MASKF, "destroying busy in thread");
                            }
                        }.start();
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "destroying busy in mainline due to exception:" + e);
                        this.utm.dispose();
                    }
                }
            }
            this.destroyed = true;
            this.notifyAll();
        }
        Trace.trace(TRACE_MASKT, "<- BusyDialog.destroy()");
    }

    public void actionPerformed(TaskActionEvent evt) {
        String command = evt.getActionCommand();
        if (command.equals("CANCEL")) {
            throw new IllegalUserDataException();
        }
    }

    static /* synthetic */ void access$300(BusyDialog x0) {
        x0.invokeImpl();
    }
}

